package main

import (
	"flag"
	"fmt"
	"go-micro.dev/v4/logger"
	"golang.org/x/sync/errgroup"
	"gomicro-base/common/logz"
	"gomicro-base/service/wallet/client"
	"gomicro-base/service/wallet/internal/conf"
	"gomicro-base/service/wallet/internal/dao"
	"gomicro-base/service/wallet/internal/server"
	"gomicro-base/service/wallet/internal/service"
	"os"
	"os/signal"
	"syscall"
)

func main() {
	flag.Parse()

	conf.LoadConfig()

	if conf.Conf.Server.Name == "" {
		panic("服务名不能为空")
	}

	// github.com/go-micro/plugins/v4/logger/zap
	logger.DefaultLogger = logz.NewLogger(conf.Conf.Log)
	defer logz.Flush()

	svc := service.New(dao.New(conf.Conf))
	microServer := server.NewMicroServer(conf.Conf, svc)

	client.NewMicroClient(conf.Conf)

	eg := errgroup.Group{}
	eg.Go(func() error {
		return microServer.Run()
	})

	eg.Go(func() error {
		ch := make(chan os.Signal, 1)
		signal.Notify(ch, syscall.SIGHUP, syscall.SIGQUIT, syscall.SIGTERM, syscall.SIGINT)
		v := <-ch
		fmt.Println()
		logz.Warnf("捕获退出信号: %v", v)
		return nil
	})

	if err := eg.Wait(); err != nil {
		logz.Error(err)
	}

}
