package conf

import (
	"flag"
	"gomicro-base/common/conf"
	"gomicro-base/common/logz"
	"gomicro-base/common/mysql"
	"gomicro-base/common/redis"
)

func init() {
	flag.StringVar(&confPath, "conf", "config/config.yaml", "配置文件路径")
}

var (
	confPath string
	Conf     = &Config{}
)

type Config struct {
	Server *Server
	Mysql  *mysql.Config
	Redis  *redis.Config
	Log    *logz.Config
}

type Server struct {
	Name       string
	ConsulAddr []string
	EtcdAddr   []string
	Grpc       struct {
		Addr string
	}
	Http struct {
		Addr string
	}
}

func LoadConfig() {
	conf.LoadFromYaml(confPath, &Conf)
}
