package dao

import (
	"context"
	"encoding/json"
	"fmt"
	"gomicro-base/common/logz"
	"gomicro-base/common/mysql"
	"gomicro-base/common/redis"
	"gomicro-base/service/member/internal/conf"
	"gomicro-base/service/member/internal/model"
	"gorm.io/gorm"
)

// Dao 查询数据库
type Dao struct {
	DB    *gorm.DB
	Redis *redis.WrapClient
}

func New(c *conf.Config) (d *Dao) {
	d = &Dao{
		DB:    mysql.NewDB(c.Mysql),
		Redis: redis.NewRedis(c.Redis),
	}
	return
}

func (d *Dao) FindCacheByPk(ctx context.Context, userIdKey string) (*model.CacheUser, error) {
	b, err := d.Redis.Get(ctx, userIdKey).Bytes()
	if err != nil {
		logz.Errorf("token error -1: %s", err)
		return nil, fmt.Errorf("token error -1")
	}

	cs := &model.CacheUser{}
	err = json.Unmarshal(b, cs)
	if err != nil {
		logz.Errorf("token error -2: %s", err)
		return nil, fmt.Errorf("token error -2")
	}
	return cs, nil
}
