package server

import (
	"fmt"
	"github.com/asim/go-micro/plugins/registry/consul/v4"
	"github.com/asim/go-micro/plugins/server/grpc/v4"
	"go-micro.dev/v4"
	"go-micro.dev/v4/registry"
	"go-micro.dev/v4/server"
	"gomicro-base/api/member"
	"gomicro-base/service/member/internal/conf"
	"gomicro-base/service/member/internal/service"
	"time"
)

func NewMicroServer(conf *conf.Config, svc *service.MemberService) micro.Service {
	reg := consul.NewRegistry(registry.Addrs(conf.Server.ConsulAddr...))
	//reg := etcd.NewRegistry(registry.Addrs(conf.Server.EtcdAddr...))
	opt := []micro.Option{
		micro.Server(grpc.NewServer()),
		micro.Name(conf.Server.Name),
		micro.Address(conf.Server.Grpc.Addr),
		micro.Registry(reg),
		micro.RegisterTTL(time.Second * 30),
		micro.RegisterInterval(time.Second * 10),
	}
	s := micro.NewService(opt...)
	s.Server().Init(server.Wait(nil))

	//reflection.Register()
	s.Init()

	err := member.RegisterMemberHandler(s.Server(), &handler{svc: svc})
	if err != nil {
		fmt.Println(err)
	}
	return s
}
