package server

import (
	"context"
	"gomicro-base/api/member"
	"gomicro-base/common/errm"
	"gomicro-base/common/hashutil"
	"gomicro-base/common/validate"
	"gomicro-base/service/member/internal/model"
	"gomicro-base/service/member/internal/service"
	"gorm.io/gorm"
)

// 检查接口实现
var _ member.MemberHandler = &handler{}

type handler struct {
	svc *service.MemberService
}

func (h *handler) CheckLoginStatus(ctx context.Context, req *member.CheckLoginReq, resp *member.CheckLoginResp) error {
	return h.svc.CheckLoginStatus(ctx, req)
}

func (h *handler) SetCredit1(ctx context.Context, req *member.SetCredit1Req, resp *member.SetCredit1Resp) error {
	return h.svc.SetCredit1(ctx, req)
}

func (h *handler) GetMemberInfo(ctx context.Context, req *member.MemberInfoReq, resp *member.MemberInfoResp) error {
	err := validate.Struct(req)
	if err != nil {
		return errm.TransParamsError(err)
	}

	m, err := h.svc.GetMemberInfo(ctx, req)
	if err != nil {
		if err == gorm.ErrRecordNotFound {
			return errm.NotFound(err.Error())
		}
		return err
	}
	*resp = *h.convertMemberModel(m)
	return nil
}

func (h *handler) convertMemberModel(m *model.ImsDbPlayMember) (resp *member.MemberInfoResp) {
	return &member.MemberInfoResp{
		UserId:   int64(m.Id),
		UserNo:   int64(m.UserNo),
		Avatar:   hashutil.Base64Decode(m.Nickname),
		Coins:    m.Credit1.IntPart(),
		CoinIcon: "https://image.whoisamy.shop/attachment/2022/02/15/ca8515b15ad91375537e4c6b67dbfbbbdb30c95b.png",
		RoomId:   "10001",
	}
}
