package service

import (
	"context"
	"fmt"
	"github.com/shopspring/decimal"
	"github.com/spf13/cast"
	"gomicro-base/api/member"
	"gomicro-base/common/errm"
	"gomicro-base/service/member/internal/dao"
	"gomicro-base/service/member/internal/model"
)

// MemberService 服务层处理逻辑
type MemberService struct {
	dao *dao.Dao
}

func New(d *dao.Dao) *MemberService {
	return &MemberService{
		dao: d,
	}
}

// CheckLoginStatus 检查登录状态
func (m *MemberService) CheckLoginStatus(ctx context.Context, req *member.CheckLoginReq) error {
	cacheUser, err := m.dao.FindCacheByPk(ctx, cast.ToString(req.UserId))
	if err != nil {
		return errm.NewMicroError(err.Error(), 400)
	}
	if cacheUser.Token != req.Token {
		return errm.NewMicroError("token error -3", 400)
	}
	return nil
}

// SetCredit1 调整余额
func (m *MemberService) SetCredit1(ctx context.Context, req *member.SetCredit1Req) error {
	sql := fmt.Sprintf(
		"update ims_db_play_member set credit1 = credit1 + %s where id = %d",
		decimal.NewFromFloat32(req.GoldNum).String(),
		req.UserId,
	)
	return m.dao.DB.Exec(sql).Error
}

// GetMemberInfo 获取用户信息
func (m *MemberService) GetMemberInfo(ctx context.Context, req *member.MemberInfoReq) (*model.ImsDbPlayMember, error) {
	res := &model.ImsDbPlayMember{}
	err := m.dao.DB.Model(&model.ImsDbPlayMember{}).
		Select([]string{"*"}).
		Where(map[string]interface{}{
			"id": req.UserId,
		}).
		Take(&res).Error
	return res, err
}
