package errm

type ErrorCode int

const (
	CommonErrorCode   ErrorCode = 1000
	ParamsErrorCode             = 1001
	NotFoundErrorCode           = 1002
	ServiceErrorCode            = 1003
	DbErrorCode                 = 1004
	SystemErrorCode             = 9999
)

var (
	codeText = map[ErrorCode]string{
		CommonErrorCode:   "error",
		ParamsErrorCode:   "params error",
		NotFoundErrorCode: "not found error",
		DbErrorCode:       "db error",
		ServiceErrorCode:  "service error",
		SystemErrorCode:   "system error",
	}
)

func GetCodeText(code ErrorCode) string {
	if v, ok := codeText[code]; ok {
		return v
	} else {
		return "error"
	}
}
