package errm

import (
	"fmt"
	"github.com/go-kratos/kratos/v2/errors"
)

func New(code ErrorCode, message string) *errors.Error {
	return errors.New(int(code), GetCodeText(code), message)
}

func Newf(code ErrorCode, format string, a ...interface{}) *errors.Error {
	return errors.Newf(int(code), GetCodeText(code), fmt.Sprintf(format, a...))
}

func CommonError(message string) *errors.Error {
	return errors.New(int(CommonErrorCode), GetCodeText(CommonErrorCode), message)
}

func ParamsError(message string) *errors.Error {
	return errors.New(int(ParamsErrorCode), GetCodeText(ParamsErrorCode), message)
}
