package tencent

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"github.com/tencentyun/tls-sig-api-v2-golang/tencentyun"
	"hilo/common/httpclient"
	"io/ioutil"
)

type (
	Config struct {
		TencentYunAppId int
		TencentYunKey   string
	}

	TencentYun struct {
		Config *Config
	}
)

var (
	Global *TencentYun
)

func SetTencentYun(ty *TencentYun) {
	Global = ty
}

func NewTencentYun(conf *Config) *TencentYun {
	return &TencentYun{Config: conf}
}

func (t *TencentYun) getAdminSig() (string, error) {
	sig, err := tencentyun.GenUserSig(t.Config.TencentYunAppId, t.Config.TencentYunKey, "administrator", 86400*180)
	if err != nil {
		return "", err
	}
	return sig, nil
}

func (t *TencentYun) GetUserSig(externalId string) (string, error) {
	sig, err := tencentyun.GenUserSig(t.Config.TencentYunAppId, t.Config.TencentYunKey, externalId, 86400*180)
	if err != nil {
		return "", err
	}
	return sig, nil
}

func (t *TencentYun) UserRegister(ctx context.Context, externalId string, nick string, avatar string) error {
	type BodyStruct struct {
		Identifier string
		Nick       string
		FaceUrl    string
	}

	type RespStruct struct {
		ActionStatus string
		ErrorInfo    string
		ErrorCode    int
	}

	url, err := t.getLoginUrl()
	if err != nil {
		return err
	}

	body := BodyStruct{
		Identifier: externalId,
		Nick:       nick,
		FaceUrl:    avatar,
	}

	jsonStr, err := json.Marshal(body)
	if err != nil {
		return err
	}

	resp, err := httpclient.Default.Post(url, "application/json", bytes.NewBuffer(jsonStr))
	defer resp.Body.Close()
	if err != nil {
		return err
	}

	result, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return err
	}

	respStruct := RespStruct{}
	if err := json.Unmarshal(result, &respStruct); err != nil {
		return err
	}
	if respStruct.ErrorCode == 0 {
		return nil
	} else {
		return fmt.Errorf(fmt.Sprintf("tencentyun UserRegister resp ErrorCode:%v, ErrorInfo:%v", respStruct.ErrorCode, respStruct.ErrorInfo))
	}
}
