package tencent

import (
	"fmt"
	"math/rand"
)

const (
	timUrl = "https://console.tim.qq.com/v4"
	//loginUrl = timUrl + "/im_open_login_svc/account_import?sdkappid={{appid}}&identifier={{externalId}}&usersig={{userSin}}&random={{random}}&contenttype=json"
)

func (t *TencentYun) getLoginUrl() (string, error) {
	sig, err := t.getAdminSig()
	if err != nil {
		return "", err
	}
	return fmt.Sprintf("%s/im_open_login_svc/account_import?sdkappid=%d&identifier=%s&usersig=%s&random=%d&contenttype=json",
		timUrl,
		t.Config.TencentYunAppId,
		"administrator",
		sig,
		rand.Intn(10000),
	), nil
}
