package conf

import (
	"flag"
	"gokratos-base/common/conf"
	"gokratos-base/common/logz"
	"gokratos-base/common/mysql"
	"gokratos-base/common/redis"
)

var (
	confPath string
	Conf     = &Config{}
)

func init() {
	flag.StringVar(&confPath, "conf", "config/config.yaml", "指定配置文件 eg: -conf config.yaml")
}

type Config struct {
	Server *Server
	Data   *Data
	Log    *logz.Config
	Consul *Consul
	Jaeger *Jaeger
}

type Consul struct {
	Addr string
}

type Jaeger struct {
	Url string
}

type Data struct {
	Mysql *mysql.Config
	Redis *redis.Config
}

type Server struct {
	Name    string
	Version string
	Grpc    struct {
		Addr    string
		Timeout int
	}
	Http struct {
		Addr    string
		Timeout int
	}
}

func LoadConfig() {
	conf.LoadFromYaml(confPath, &Conf)
}
