package server

import (
	"context"
	"github.com/go-kratos/kratos/v2/middleware"
	"github.com/go-kratos/kratos/v2/transport"
	"gokratos-base/common/errm"
	"gokratos-base/common/validate"
)

// ValidateParams 验证参数
func ValidateParams() middleware.Middleware {
	return func(handler middleware.Handler) middleware.Handler {
		return func(ctx context.Context, req interface{}) (interface{}, error) {
			if tr, ok := transport.FromServerContext(ctx); ok {
				err := validate.Struct(req)
				if err != nil {
					logHelper.WithContext(ctx).Warnf("[%s]参数验证失败: %s", tr.Operation(), err.Error())
					return nil, errm.ParamsError(err.Error())
				}
			}
			return handler(ctx, req)
		}
	}
}
